package com.biz.crm.nebular.sfa.asexecution.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigInteger;

/**
 * 方案活动兑付产品;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动兑付产品;")
@SaturnEntity(name = "SfaAsCashingProductRespVo", description = "方案活动兑付产品;")
public class SfaAsCashingProductRespVo extends CrmExtTenVo {

    @ApiModelProperty("兑付id")
    @SaturnColumn(description = "兑付id")
    private String cashingId;

    @ApiModelProperty("产品编码")
    @SaturnColumn(description = "产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @SaturnColumn(description = "产品名称")
    private String productName;

    @ApiModelProperty("数量")
    @SaturnColumn(description = "数量")
    private BigInteger productNum;
}