package com.biz.crm.nebular.sfa.asexecution.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 方案活动协议;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动协议;")
@SaturnEntity(name = "SfaAsTreatyRespVo", description = "方案活动协议;")
@CrmColumnResolve
public class SfaAsTreatyRespVo extends CrmExtTenVo {

    private static final long serialVersionUID = 2827243195999512410L;
    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("活动类型")
    @SaturnColumn(description = "活动类型")
    @CrmDict(typeCode = "scheme_type", dictCodeField = "activityType")
    private String activityType;

    @ApiModelProperty("活动执行开始时间")
    private String activityStartTime;

    @ApiModelProperty("活动执行结束时间")
    private String activityEndTime;

    @ApiModelProperty("经销商编码")
    private String dealerCode;

    @ApiModelProperty("经销商名称")
    private String dealerName;

    @ApiModelProperty("终端编码")
    @SaturnColumn(description = "终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    @SaturnColumn(description = "终端名称")
    private String terminalName;

    @ApiModelProperty("陈列品牌")
    @SaturnColumn(description = "陈列品牌")
    private String displayBrand;

    @ApiModelProperty("陈列品项")
    @SaturnColumn(description = "陈列品项")
    private String displayItem;

    @ApiModelProperty("陈列位置")
    @SaturnColumn(description = "陈列位置")
    private String displayPlace;

    @ApiModelProperty("陈列规格")
    @SaturnColumn(description = "陈列规格")
    private String displaySpecs;

    @ApiModelProperty("陈列件数")
    @SaturnColumn(description = "陈列件数")
    private String displayNumber;

    @ApiModelProperty("陈列开始时间")
    @SaturnColumn(description = "陈列开始时间")
    private String displayStartTime;

    @ApiModelProperty("陈列结束时间")
    @SaturnColumn(description = "陈列结束时间")
    private String displayEndTime;

    @ApiModelProperty("陈列月份")
    @SaturnColumn(description = "陈列月份")
    private String displayMonth;


    /**根据活动申请时选择的兑付方式进行展示对应的协议**/
    /**
     * 现金兑付
     */
    @ApiModelProperty("每月支付现金")
    @SaturnColumn(description = "每月支付现金")
    private BigDecimal monthPayAmount;

    @ApiModelProperty("合计奖励现金")
    @SaturnColumn(description = "合计奖励现金")
    private BigDecimal totalAmount;

    @ApiModelProperty("奖励收款人")
    @SaturnColumn(description = "奖励收款人")
    private String payee;

    @ApiModelProperty("联系电话")
    @SaturnColumn(description = "联系电话")
    private String contactPhone;


    /**
     * '协议编码'
     */
    @ApiModelProperty("协议编码")
    @SaturnColumn(description = "协议编码")
    private String treatyCode;

    /**
     * '协议状态编码'
     */
    @ApiModelProperty("协议状态编码")
    @SaturnColumn(description = "协议状态编码")
    private String treatyStatus;

    /**
     * '协议状态'
     */
    @ApiModelProperty("协议状态")
    private String treatyStatusDesc;

    /**
     * '图片对象名称'
     */
    @ApiModelProperty("pdf文件对象名称")
    private String objectName;

    /**
     * '图片相对路径'
     */
    @ApiModelProperty("pdf文件地址")
    private String urlPath;

    /**
     * '图片路径地址'
     */
    @ApiModelProperty("pdf文件前缀")
    private String urlPathPrefix;


    @ApiModelProperty("协议来源-数据字典(agreement_source)")
    private String treatySource;

    /**
     * 货品兑付
     */
    @ApiModelProperty("方案活动协议-货物兑换产品")
    private List<SfaAsTreatyConvertProductRespVo> asTreatyConvertProductList;

    @ApiModelProperty("方案活动协议-陈列产品")
    private List<SfaAsTreatyDisplayProductRespVo> asTreatyDisplayProductList;

    @ApiModelProperty("方案活动协议签字图片地址")
    private SfaAsTreatySignRespVo asTreatySign;
}