package com.biz.crm.nebular.sfa.audit.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 产品价格稽查-产品表返回vo
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "产品价格稽查-产品表")
public class SfaAuditProductPriceProRespVo extends CrmExtTenVo {
    @ApiModelProperty("产品稽查编码")
    private String auditCode;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("终端标准零售价")
    private BigDecimal terminalStandardRetailPrice;

    @ApiModelProperty("终端实际零售价")
    private BigDecimal terminalActualRetailPrice;

    @ApiModelProperty("销售标准是否达标")
    private Boolean salesTarget;

}