package com.biz.crm.nebular.sfa.checkin.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

/**
 * 签到组-签到图片返回vo
 *
 * @author fily
 * @date 2021-01-05 13:12:39
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "签到组-签到图片")
@SaturnEntity(name = "SfaCheckInSignRecordPictureRespVo", description = "签到组-签到图片")
public class SfaCheckInSignRecordPictureRespVo {
    @ApiModelProperty("签到记录id")
    @SaturnColumn(description = "签到记录id")
    private String signRecordId;

    @ApiModelProperty("照片路径(物理路径)")
    @SaturnColumn(description = "照片路径(物理路径)")
    private String picPath;

    @ApiModelProperty("照片地址")
    @SaturnColumn(description = "照片地址")
    private String picUrl;

    @ApiModelProperty("照片描述")
    @SaturnColumn(description = "照片描述")
    private String picDesc;

    public String getUrl() {
        if(StringUtils.isBlank(this.picUrl) || StringUtils.isBlank(this.picPath)){
            return null;
        }
        return this.picUrl + this.picPath;
    }
}