package com.biz.crm.nebular.sfa.collection.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 拜访步骤配置(角色) 返回vo
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤配置(角色) ")
@SaturnEntity(name = "SfaVisitRoleConfigRespVo", description = "拜访步骤配置(角色) ")
public class SfaVisitRoleConfigRespVo extends CrmExtTenVo {

    @ApiModelProperty("拜访步骤配置(角色)编码 拜访步骤配置(角色)编码")
    @SaturnColumn(description = "拜访步骤配置(角色)编码 拜访步骤配置(角色)编码")
    private String visitRoleCode;

    @ApiModelProperty("角色编码 角色编码")
    @SaturnColumn(description = "角色编码 角色编码")
    private String roleCode;

    @ApiModelProperty("角色名称 角色名称")
    @SaturnColumn(description = "角色名称 角色名称")
    private String roleName;

    @ApiModelProperty("拜访类型 拜访类型")
    @SaturnColumn(description = "拜访类型 拜访类型")
    private String visitType;

    @ApiModelProperty("拜访类型描述 拜访类型描述")
    @SaturnColumn(description = "拜访类型描述 拜访类型描述")
    @CrmDict(typeCode = "visitType",dictCodeField = "visitType")
    private String visitTypeDesc;

    @ApiModelProperty("客户类型 客户类型")
    @SaturnColumn(description = "客户类型 客户类型")
    private String sfacusType;

    @ApiModelProperty("客户类型描述 客户类型描述")
    @SaturnColumn(description = "客户类型描述 客户类型描述")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "sfacusType")
    private String sfacusTypeDesc;

    @ApiModelProperty("拜访步骤 拜访步骤")
    @SaturnColumn(description = "拜访步骤 拜访步骤")
    private String directoryDescs;

    @ApiModelProperty("是否离线操作")
    private String isOffLine;

    @ApiModelProperty("是否离线操作")
    @CrmDict(typeCode = "yesOrNo",dictCodeField = "isOffLine")
    private String isOffLineDesc;

    @ApiModelProperty("拜访步骤配置(角色)-拜访步骤表单配置明细")
    @SaturnColumn(description = "拜访步骤配置(角色)-拜访步骤表单配置明细")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaVisitRoleDirectoryRespVo> visitRoleDirectoryRespVos;

    @ApiModelProperty("创建时间")
    private String createDateTime;

    @ApiModelProperty("修改时间")
    private String updateDateTime;

    @ApiModelProperty("客户细类")
    private String clientSubclass;

    @ApiModelProperty("客户细类")
    private String clientSubclassName;

}