package com.biz.crm.nebular.sfa.helpdefense.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * 协防执行明细;请求vo
 *
 * @author lf
 * @date 2021-01-05 15:45:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaHelpDefenseDetailReqVo", description = "协防执行明细;")
public class SfaHelpDefenseDetailReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("协防主键id")
    private String helpDefenseId;

    @ApiModelProperty("被协防人员账号")
    private String coverHelpUserName;

    @ApiModelProperty("被协防人员姓名")
    private String coverHelpRealName;

    @ApiModelProperty("被协防组织编码")
    private String coverHelpOrgCode;

    @ApiModelProperty("被协防组织名称")
    private String coverHelpOrgName;

    @ApiModelProperty("被协防职位编码")
    private String coverHelpPosCode;

    @ApiModelProperty("被协防职位名称")
    private String coverHelpPosName;

    @ApiModelProperty("网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    private String clientType;

    @ApiModelProperty("网点地址;网点地址")
    private String clientAddress;

    @ApiModelProperty("网点联系人")
    private String clientContacts;

    @ApiModelProperty("网点图片")
    private String clientPhoto;

    @ApiModelProperty("网点电话 网点电话")
    private String clientPhone;

    @ApiModelProperty("经度;协访网点经度")
    private BigDecimal longitude;

    @ApiModelProperty("纬度;协访网点纬度")
    private BigDecimal latitude;

    @ApiModelProperty("协防状态(0-待协防,1,协防中,2-已协防,3-已过期)")
    private String helpDefenseStatus;

}