package com.biz.crm.nebular.sfa.helpdefense.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 协访执行明细;返回vo
 *
 * @author lf
 * @date 2021-01-05 15:45:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "协访执行明细;")
@SaturnEntity(name = "SfaHelpDefenseDetailRespVo", description = "协访执行明细;")
public class SfaHelpDefenseDetailRespVo extends CrmExtTenVo {

    @ApiModelProperty("协访主键id")
    private String helpDefenseId;

    @ApiModelProperty("被协访人员账号")
    @SaturnColumn(description = "被协访人员账号")
    private String coverHelpUserName;

    @ApiModelProperty("被协访人员姓名")
    @SaturnColumn(description = "被协访人员姓名")
    private String coverHelpRealName;

    @ApiModelProperty("被协访组织编码")
    @SaturnColumn(description = "被协访组织编码")
    private String coverHelpOrgCode;

    @ApiModelProperty("被协访组织名称")
    @SaturnColumn(description = "被协访组织名称")
    private String coverHelpOrgName;

    @ApiModelProperty("被协访职位编码")
    @SaturnColumn(description = "被协访职位编码")
    private String coverHelpPosCode;

    @ApiModelProperty("被协访职位名称")
    @SaturnColumn(description = "被协访职位名称")
    private String coverHelpPosName;

    @ApiModelProperty("网点id")
    @SaturnColumn(description = "网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    @SaturnColumn(description = "网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    @SaturnColumn(description = "网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    @SaturnColumn(description = "网点类型")
    private String clientType;

    @ApiModelProperty("网点类型")
    private String clientTypeDesc;

    @ApiModelProperty("网点地址;网点地址")
    private String clientAddress;

    @ApiModelProperty("网点联系人")
    private String clientContacts;

    @ApiModelProperty("网点图片")
    private String clientPhoto;

    @ApiModelProperty("网点电话 网点电话")
    private String clientPhone;

    @ApiModelProperty("经度;协访网点经度")
    private BigDecimal longitude;

    @ApiModelProperty("纬度;协访网点纬度")
    private BigDecimal latitude;

    @ApiModelProperty("协访状态(0-待协访,1,协访中,2-已协访,3-已过期)")
    private String helpDefenseStatus;

    @ApiModelProperty("协访状态(0-待协访,1,协访中,2-已协访,3-已过期)")
    private String helpDefenseStatusDesc;
}