package com.biz.crm.nebular.sfa.moblie.req;

import com.biz.crm.nebular.mdm.Ext30Vo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 附近客户 请求vo
 *
 * @author yangshan
 * @date 2021/3/9 15:10
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaNearbyCustomerReqVo", description = "附近客户 ")
public class SfaNearbyCustomerReqVo extends Ext30Vo {

    /**
     * 经纬度
     */
    @ApiModelProperty("当前经纬度，格式104.10194,30.65984")
    private String location;

    /**
     * 每页数据的数量
     */
    @ApiModelProperty("每页数据的数量")
    private Integer pageSize;

    /**
     * 页码
     */
    @ApiModelProperty("页码")
    private Integer pageNum;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String clientName;

    /**
     * 时间
     */
    @ApiModelProperty("时间(yyyy-MM-dd)")
    private String visitTime;

    /**
     * 地图数据源
     */
    @ApiModelProperty("地图数据，默认高德（2-腾讯地图；3-高德地图）")
    private String mapData;

}
