package com.biz.crm.nebular.sfa.tpmact.actcollect;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.sfa.tpmact.actcollect
 * @date 2021/6/13 20:37
 */
@Data
@ApiModel(value = "SfaTpmActCollectVo", description = "tpm活动-活动数据采集")
@EqualsAndHashCode(callSuper = false)
public class SfaTpmActCollectVo extends CrmExtTenVo implements Serializable, VisitBaseVo.StepExecuteDataReq {

    public static final long serialVersionUID = -15414546523899753l;

    public static final String REDIS_HASH_KEY = "sfa_tpm_act_collect_data";

    public static final Long redis_expire_time = Long.valueOf(60 * 60 * 5);

    @ApiModelProperty("步骤编码-可不传")
    private String stepCode;

    @ApiModelProperty("表单Id-可不传")
    private String formId;

    @ApiModelProperty("主键id")
    private String id;

    @ApiModelProperty("拜访明细id-工作台可不传")
    private String visitPlanInfoId;

    @ApiModelProperty("经度-工作台不传")
    private String longitude;

    @ApiModelProperty("维度-工作台不传")
    private String latitude;

    @ApiModelProperty("网店编码")
    private String clientCode;

    @ApiModelProperty("网店名称")
    private String clientName;

    @ApiModelProperty("活动描述")
    private String actDesc;

    @ApiModelProperty("活动编码")
    private String actDetailCode;

    @ApiModelProperty("表单信息以及图片")
    private List<CollectForm> collectFormList;

    @ApiModelProperty("活动数据状态")
    private String lineStatus;

    @ApiModelProperty("活动要求")
    private String actDemand;

    @Data
    @ApiModel(value = "CollectForm",description = "动态表单-拍照图片")
    public static class CollectForm{

        @ApiModelProperty("表单名称")
        private String exampleName;

        @ApiModelProperty("表单编码")
        private String exampleCode;

        @ApiModelProperty("示例图片地址")
        private List<String> pictList;

        @ApiModelProperty("图片")
        private List<AttachmentVo> attachmentList;

    }

    public static String getRedisHashKey(String id) {
        return REDIS_HASH_KEY + RedisParam.DELIMITER + id;
    }

    public static Map<String,SfaTpmActCollectVo> buildMap(String id,SfaTpmActCollectVo vo){
        Map<String,SfaTpmActCollectVo> map = new HashMap<>();
        map.put(id,vo);
        return map;
    }
}
