package com.biz.crm.nebular.sfa.tpmact.displaytreaty;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.sfa.tpmact.displaytreaty
 * @date 2021/6/12 18:59
 */
@Data
@ApiModel(value = "DisplayTreatyVo",description = "陈列协议vo")
public class DisplayTreatyVo extends CrmExtTenVo implements Serializable {

    @ApiModelProperty("主键id")
    private String id;

    @ApiModelProperty("拜访明细id-工作台可不传")
    private String visitPlanInfoId;

    @ApiModelProperty("协议编码")
    private String treatyCode;

    @ApiModelProperty("协议状态")
    private String treatyStatus;

    @ApiModelProperty("经销商名称")
    private String dealerCode;

    /**
     * 经销商名称
     */
    @ApiModelProperty("经销商名称")
    private String dealerName;

    /**
     * 活动编码
     */
    @ApiModelProperty("活动编码")
    private String activityCode;

    /**
     * 终端编码
     */
    @ApiModelProperty("终端编码")
    private String terminalCode;

    /**
     * 终端名称
     */
    @ApiModelProperty("终端名称")
    private String terminalName;

    /**
     * 陈列品牌
     */
    @ApiModelProperty("陈列品牌")
    private String displayBrand;

    /**
     * 陈列品项
     */
    @ApiModelProperty("陈列品项")
    private String displayItem;

    /**
     * 陈列位置
     */
    @ApiModelProperty("陈列位置")
    private String  displayPlace;

    /**
     * 陈列规格
     */
    @ApiModelProperty("陈列规格")
    private String  displaySpecs;

    /**
     * 陈列件数
     */
    @ApiModelProperty("陈列件数")
    private String  displayNumber;

    /**
     * 陈列开始时间
     */
    @ApiModelProperty("陈列开始时间")
    private String  displayStartTime;

    /**
     * 陈列结束时间
     */
    @ApiModelProperty("陈列结束时间")
    private String  displayEndTime;

    /**
     * 陈列月份
     */
    @ApiModelProperty("陈列月份")
    private String  displayMonth;


    /**
     * 经度
     */
    @ApiModelProperty("经度-工作台不传")
    private String longitude;

    /**
     * 维度
     */
    @ApiModelProperty("维度-工作台不传")
    private String latitude;

    /**
     * 来源
     */
    @ApiModelProperty("来源-可不传")
    private String actDisplaySourceType;

    @ApiModelProperty("步骤编码-可不传")
    private String stepCode;


    @ApiModelProperty("陈列产品集合")
    private List<DisplayProduct> displayProductList;


    @ApiModelProperty("签名照")
    private SignPic signPic;

    @ApiModelProperty("店主手机号")
    private String storePhone;

    @ApiModelProperty("短信验证码")
    private String verificationCode;

    @ApiModelProperty("数据状态")
    private String lineStatus;



    @Data
    @ApiModel(description = "陈列产品",value = "DisplayProduct")
    public static class DisplayProduct{

        @ApiModelProperty("产品编码")
        private String productCode;

        @ApiModelProperty("产品名称")
        private String productName;
    }

    @Data
    @ApiModel(value = "signPic",description = "签名照")
    public static class SignPic{

        @ApiModelProperty("签字人名")
        private String signName;

        @ApiModelProperty("访问前缀")
        private String urlPathPrefix;

        @ApiModelProperty("路径")
        private String urlPath;

        @ApiModelProperty("文件名称")
        private String fileName;

        @ApiModelProperty("对象名")
        private String objectName;

        @ApiModelProperty("文件后缀")
        private String suffix;

        @ApiModelProperty("类型（SIGN_签名照/PDF_文件/IMAGE_图片）")
        private String fileType;
    }
}
