package com.biz.crm.nebular.sfa.tpmact.displaytreaty;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.sfa.tpmact.displaytreaty
 * @date 2021/6/12 17:02
 */
@Data
@ApiModel(value = "GoodsTreatyVo",description = "货品协议")
public class GoodsTreatyVo extends DisplayTreatyVo implements Serializable, VisitBaseVo.StepExecuteDataReq {

    @ApiModelProperty("支付货品")
    private List<ConvertProduct> payGoodList;

    @ApiModelProperty("奖励货品")
    private List<ConvertProduct> rewardGoodList;

    @Data
    @ApiModel(value = "ConvertProduct",description = "货品信息")
    public static class ConvertProduct{
        @ApiModelProperty("商品编码")
        private String productCode;

        @ApiModelProperty("商品名称")
        private String productName;

        @ApiModelProperty("商品数量")
        private BigInteger productNum;

        @ApiModelProperty("规格")
        private String spec;

        @ApiModelProperty("价格")
        private BigDecimal price;
    }



}
