package com.biz.crm.nebular.sfa.tpmact.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * tpm活动明细请求vo
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaTpmActDetailReqVo", description = "tpm活动明细")
public class SfaTpmActDetailReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("企业组织")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("费用申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("是否核销")
    private String isAudit;

    @ApiModelProperty("是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("支付方式名称")
    private String payTypeName;

    @ApiModelProperty("支付方式类型")
    private String payTypeType;

    @ApiModelProperty("活动细类（执行控制）")
    private SfaTpmCostTypeFineReqVo fineRespVo;

    @ApiModelProperty("本品商品集合")
    private List<SfaTpmActDetailProductReqVo> normalProductList;

    @ApiModelProperty("赠品商品集合")
    private List<SfaTpmActDetailProductReqVo> giftProductList;

}