package com.biz.crm.nebular.sfa.tpmact.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 活动细类（执行控制）请求vo
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaTpmCostTypeFineReqVo", description = "活动细类（执行控制）")
public class SfaTpmCostTypeFineReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("是否采集活动数据(Y/N)")
    private String isCollectActData;

    @ApiModelProperty("是否采集分销订单(Y/N)")
    private String isCollectDistributionOrder;

    @ApiModelProperty("是否签署陈列协议(Y/N)")
    private String isSignDisplayAgreement;

    @ApiModelProperty("兑付方式(数据字典:payment_method,现金兑付,货品兑付)")
    private String paymentMethod;

    @ApiModelProperty("采集要求(集合的json)")
    private String collectRequireList;

    @ApiModelProperty("采集要求(集合的json)")
    private List<SfaTpmAuditCollectExampleReqVo> collectRequires;

}