package com.biz.crm.nebular.sfa.tpmact.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动细类（执行控制）返回vo
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动细类（执行控制）")
public class SfaTpmCostTypeFineRespVo extends CrmExtTenVo {
    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("是否采集活动数据(Y/N)")
    private String isCollectActData;

    @ApiModelProperty("是否采集分销订单(Y/N)")
    private String isCollectDistributionOrder;

    @ApiModelProperty("是否签署陈列协议(Y/N)")
    private String isSignDisplayAgreement;

    @ApiModelProperty("是否控制活动费用(Y/N)")
    private String isControlActFee;

    @ApiModelProperty("兑付方式(数据字典:payment_method,现金兑付,货品兑付)")
    private String paymentMethod;

    @ApiModelProperty("采集要求(集合的json)")
    private String collectRequireList;

}