package com.biz.crm.nebular.sfa.visitinfo.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 经销商拜访明细;返回vo
 *
 * @author lf
 * @date 2020-11-17 11:22:50
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访与销售走势图;")
@SaturnEntity(name = "SfaVisitAndSalesTrendChartRespVo", description = "拜访与销售走势图;")
public class SfaVisitAndSalesTrendChartRespVo {

    @ApiModelProperty("年月")
    private String yearMonth;

    @ApiModelProperty("月份描述")
    private String monthDes;

    @ApiModelProperty("拜访数")
    private BigDecimal visitNumber = BigDecimal.ZERO;

    @ApiModelProperty("销售数")
    private BigDecimal salesNumber = BigDecimal.ZERO;

    public SfaVisitAndSalesTrendChartRespVo() {
    }

    public SfaVisitAndSalesTrendChartRespVo(String yearMonth, BigDecimal visitNumber, BigDecimal salesNumber) {
        this.yearMonth = yearMonth;
        this.visitNumber = visitNumber;
        this.salesNumber = salesNumber;
    }
}