package com.biz.crm.nebular.sfa.visitinfo.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 经销商拜访明细;返回vo
 *
 * @author lf
 * @date 2020-11-17 11:22:50
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "近段时间拜访排行明细;")
@SaturnEntity(name = "SfaVisitRankingDetailedRespVo", description = "近段时间拜访排行明细;")
public class SfaVisitRankingDetailedRespVo {

    @ApiModelProperty("人员账号")
    private String username;

    @ApiModelProperty("真实姓名")
    private String realname;

    @ApiModelProperty("职位编码")
    private String poscode;

    @ApiModelProperty("职位描述")
    private String posname;

    @ApiModelProperty("拜访数")
    private BigDecimal visitNumber = BigDecimal.ZERO;

    public SfaVisitRankingDetailedRespVo() {
    }

    public SfaVisitRankingDetailedRespVo(String poscode, BigDecimal visitNumber) {
        this.poscode = poscode;
        this.visitNumber = visitNumber;
    }
}