package com.biz.crm.nebular.sfa.visitstep.req;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 拜访步骤查询VO
 * @author YuanZiJian
 * @date 2021/2/4 14:53
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤查询")
@SaturnEntity(name = "SfaVisitStepFromSearchReqVo", description = "拜访步骤查询Vo")
public class SfaVisitStepFromSearchReqVo extends PageVo {
    /**
     * 步骤表单编码
     */
    @ApiModelProperty("查询条件（可模糊）——步骤表单编码")
    private String fromCode;
    /**
     * 步骤表单名称
     */
    @ApiModelProperty("查询条件（可模糊）——步骤表单名称")
    private String fromName;


    /**
     * 拜访类型——ps:这里不是传名称。直接传对应编码
     */
    @ApiModelProperty("拜访类型——ps:这里不是传名称。直接传对应编码")
    private String visitType;
    /**
     * 客户类型——ps:这里不是传名称，直接传对应编码
     */
    @ApiModelProperty("客户类型——ps:这里不是传名称，直接传对应编码")
    private String customerType;
    /**
     * 客户类型——ps:这里不是传名称，直接传对应编码
     */
    @ApiModelProperty("客户细类——ps:这里不是传名称，直接传对应编码")
    private String clientSubclass;
    @ApiModelProperty("客户细类名称")
    private String clientSubclassName;

    @ApiModelProperty(name = "模板-直接传对应编码")
    private String pageCode;

    /**
     * 步骤编码
     */
    @ApiModelProperty("步骤编码-直接传对应编码")
    private String stepCode;

    @ApiModelProperty("启用状态")
    private String enableStatus;

}
