package com.biz.crm.nebular.sfa.visitstep.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author ren.gang
 * @ClassName SfaVisitStepOrderDetailReqVo.java
 * @Description 终端进货量分析查询vo
 * @createTime 2021年01月12日 14:49:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitStepOrderStockAnalysisReqVo", description = "终端进货量分析查询vo")
public class SfaVisitStepOrderStockAnalysisReqVo extends PageVo {


    @ApiModelProperty("客户编码")
    private String clientCode;

    @ApiModelProperty("客户名称")
    private String clientName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("下单时间-开始")
    private String orderTimeStart;

    @ApiModelProperty("下单时间-结束")
    private String orderTimeEnd;
}
