package com.biz.crm.nebular.sfa.visitstep.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 拜访步骤列表——Vo
 *
 * @author YuanZiJian
 * @date 2021/2/4 14:05
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤列表Vo")
@SaturnEntity(name = "SfaVisitStepFromListRespVo", description = "拜访步骤列表Vo")
public class SfaVisitStepFromListRespVo extends CrmBaseVo {

    /**
     * 页面编码——（模板）
     */
    @ApiModelProperty("页面编码——（即模板）")
    private String pageCode;
    /**
     * 页面编码名称——（模板名称）查询用！！
     */
    @ApiModelProperty("页面编码名称——（模板名称）查询用！！")
    @CrmDict(typeCode = "sfa_visit_step", dictCodeField = "pageCode")
    private String pageCodeName;
    /**
     * 步骤表单名称
     */
    @ApiModelProperty("步骤表单名称")
    private String fromName;
    /**
     * 拜访类型
     */
    @ApiModelProperty("拜访类型")
    private String visitType;
    /**
     * 拜访类型名称 查询用！！
     */
    @ApiModelProperty("拜访类型名称——查询用！！")
    @CrmDict(typeCode = "sfaVisitType", dictCodeField = "visitType")
    private String visitTypeName;
    /**
     * 客户类型
     */
    @ApiModelProperty("客户类型")
    private String customerType;
    /**
     * 客户类型名称 查询用！！
     */
    @ApiModelProperty("客户类型名称——查询用！！")
    @CrmDict(typeCode = "sfacusType", dictCodeField = "customerType")
    private String customerTypeName;

    @ApiModelProperty("客户细类")
    private String clientSubclass;

    @ApiModelProperty("客户细类")
    private String clientSubclassName;

    /**
     * 有效期开始时间
     */
    @ApiModelProperty("有效期开始时间")
    private String startTime;
    /**
     * 有效期结束时间
     */
    @ApiModelProperty("有效期结束时间")
    private String endTime;
    /**
     * 有效期类型
     */
    @ApiModelProperty("有效期类型")
    private String timeType;
    /**
     * 有效期类型名称 查询用！！
     */
    @ApiModelProperty("有效期类型——查询用！！")
    @CrmDict(typeCode = "timeType", dictCodeField = "timeType")
    private String timeTypeName;

    /**
     * 是否获取定位信息
     */
    @ApiModelProperty("是否获取定位信息")
    private String locateType;

    /**
     * 距离
     */
    @ApiModelProperty("距离")
    private String distance;

    @ApiModelProperty("是否获取定位信息-名称")
    @CrmDict(typeCode = "doNot", dictCodeField = "locateType")
    private String locateTypeName;

    /**
     * 步骤编码
     */
    @ApiModelProperty("步骤编码")
    private String stepCode;
}
