package com.biz.crm.nebular.sfa.worksign.form.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author chenlong
 * @Description 考勤报表请求Vo
 * @createTime 2022年03月24日 16:00:00
 */
@Data
@ApiModel("考勤报表统计请求Vo")
public class SfaWorkSignStatisticsReqVo extends PageVo {

    @ApiModelProperty(value = "查询日期年月日", required = true)
    private String yearMonthDay;

    @ApiModelProperty("区域")
    private String orgName;

    @ApiModelProperty("时间维度 日:DAY;周:WEEK;月:MONTH")
    private String timeType;

    @ApiModelProperty(value = "查询开始年月日", hidden = true)
    private String startTime;

    @ApiModelProperty(value = "查询结束年月日", hidden = true)
    private String endTime;

    @ApiModelProperty(value = "区域编码列表", hidden = true)
    private List<String> orgCodeList;

}
