package com.biz.crm.nebular.sfa.worksign.form.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author chenlong
 * @Description 考勤报表返回Vo
 * @createTime 2022年03月24日 16:06:00
 */
@Data
@ApiModel("月度考勤报表返回Vo")
public class SfaWorkSignStatisticsRespVo {

    @ApiModelProperty("日期")
    private String yearMonthDay;

    @ApiModelProperty("统计维度(日:DAY;周:WEEK;月:MONTH)")
    private String timeType;

    @ApiModelProperty("区域")
    private String orgName;

    @ApiModelProperty("区域编码")
    private String orgCode;

    @ApiModelProperty("在勤人数")
    private Integer signCount;

    @ApiModelProperty("缺勤人数")
    private Integer noSignCount;

    @ApiModelProperty("人员总数")
    private Integer totalSignCount;

    @ApiModelProperty("出勤率")
    private String signRate;

    @ApiModelProperty("实际工作时长")
    private BigDecimal actualWorkHours;

    @ApiModelProperty("应工作时长")
    private BigDecimal requiredWorkHours;

    @ApiModelProperty("人均工作时长")
    private BigDecimal perCapitaWorkHours;

}
