package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * 考勤照片 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Data
@ApiModel(value = "考勤照片 ")
public class SfaWorkSignPictureRespVo extends CrmBaseVo {
    @ApiModelProperty("打卡记录id 打卡记录id")
    private String wsRecordId;

    @ApiModelProperty("照片路径(物理路径) 照片路径(物理路径)")
    private String picPath;

    @ApiModelProperty("照片地址 照片地址")
    private String picUrl;

    @ApiModelProperty("照片描述 照片描述")
    private String picDesc;


    public String getUrl() {
        if(StringUtils.isBlank(this.picUrl) || StringUtils.isBlank(this.picPath)){
            return null;
        }
        return this.picUrl + this.picPath;
    }
}