package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 考勤打卡记录表 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "考勤打卡记录表 ")
public class SfaWorkSignRecordRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("考勤规则明细表id 考勤规则明细表id")
    private String wsRuleInfoId;

    @ApiModelProperty("打卡类型 CLOCK_IN : 上班签到; CLOCK_OUT : 下班签退;")
    private String workSignType;

    @ApiModelProperty("打卡类型描述 打卡类型描述")
    private String workSignDesc;

    @ApiModelProperty("考勤时间 考勤时间(HH:mm:ss)")
    private String workSignTime;

    @ApiModelProperty("下班打卡时间")
    private String sfaSignTime;
    @ApiModelProperty("考勤日期")
    private String ruleDate;
    @ApiModelProperty("考勤地点 考勤地点")
    private String workSignPlace;

    @ApiModelProperty("打卡经度 打卡经度")
    private String lngIn;

    @ApiModelProperty("打卡纬度 打卡纬度")
    private String latIn;

    @ApiModelProperty("考勤状态 NONE:未打卡;OK:正常;BE_LATE:迟到;LEAVE_EARLY:早退;")
    private String workSignStatus;

    @ApiModelProperty("考勤状态名称")
    @CrmDict(typeCode = "work_sign_status" , dictCodeField = "workSignStatus")
    private String workSignStatusName;


    @ApiModelProperty("考勤地点状态 OK : 正常; EX : 异常;")
    private String wsPlaceStatus;

    @ApiModelProperty("考勤地点状态名称")
    @CrmDict(typeCode = "wsPlaceStatus" , dictCodeField = "wsPlaceStatus")
    private String wsPlaceStatusName;


    @ApiModelProperty("打卡人员id 打卡人员id")
    private String wsUserId;

    @ApiModelProperty("打卡人员账号 打卡人员账号")
    private String wsUserName;

    @ApiModelProperty("打卡人员名称 打卡人员名称")
    private String wsRealName;

    @ApiModelProperty("打卡职位id 打卡职位id")
    private String wsPosId;

    @ApiModelProperty("打卡职位编码 打卡职位编码")
    private String wsPosCode;

    @ApiModelProperty("打卡职位名称 打卡职位名称")
    private String wsPosName;

    @ApiModelProperty("打卡组织id 打卡组织id")
    private String wsOrgId;

    @ApiModelProperty("打卡组织编码 打卡组织编码")
    private String wsOrgCode;

    @ApiModelProperty("打卡组织名称 打卡组织名称")
    private String wsOrgName;
    /**
     * 上级组织编码 组织编码
     */
    private String wsParentOrgCode;

    /**
     * 上级组织名称 组织名称
     */
    private String wsParentOrgName;
    /**
     * 上班打卡开始时间 上班打卡开始时间(HH:mm:ss)
     */
    @ApiModelProperty("上班打卡开始时间")
    private String gotoStartTime;

    @ApiModelProperty("上班打卡时间")
    private String gotoTime;
    /**
     * 上班打卡结束时间 上班打卡结束时间(HH:mm:ss)
     */
    @ApiModelProperty("上班打卡结束时间")
    private String gotoEndTime;


    @ApiModelProperty("下班打卡时间")
    private String gooffTime;
    /**
     * 下班打卡开始时间 下班打卡开始时间(HH:mm:ss)
     */
    @ApiModelProperty("下班打卡开始时间")
    private String gooffStartTime;

    /**
     * 下班打卡结束时间 下班打卡结束时间(HH:mm:ss)
     */
    @ApiModelProperty("下班打卡结束时间")
    private String gooffEndTime;
    /**
     * 拍照打卡;拍照打卡(Y:员工打卡时必须拍照)
     */
    @ApiModelProperty("拍照打卡(Y:员工打卡时必须拍照)")
    private String wsrPhotograph;

    @ApiModelProperty("考勤照片 考勤照片")
    private List<SfaWorkSignPictureRespVo> sfaWorkSignPictureRespVos;

    @ApiModelProperty("是否以工作日进行打卡操作：true:是，false:否")
    private Boolean executeAsWorkingDay;

}