package com.biz.crm.nebular.sfa.worksummary.resp;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 工作总结点赞记录返回vo
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作总结点赞记录")
@SaturnEntity(name = "SfaWorkSummaryLikeRespVo", description = "工作总结点赞记录")
public class SfaWorkSummaryLikeRespVo extends CrmBaseVo {
    private static final long serialVersionUID = 4616748474330191067L;
    @ApiModelProperty("被点赞数据ID（工作总结ID/评论ID）")
    @SaturnColumn(description = "被点赞数据ID（工作总结ID/评论ID）")
    private String businessId;

    @ApiModelProperty("工作动态（总结）ID")
    @SaturnColumn(description = "工作动态（总结）ID")
    private String summaryId;

    @ApiModelProperty("人员信息")
    @SaturnColumn(description = "人员信息")
    private String userName;

    @ApiModelProperty("头像")
    @SaturnColumn(description = "头像")
    private String photo;

    @ApiModelProperty("点赞数")
    @SaturnColumn(description = "点赞数")
    private String sumCount;
}