package com.biz.crm.nebular.tpm.account.req;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.tpm.account.TpmAccountFileVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import java.util.Set;

import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 费用上账表;请求vo
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAccountDetailReqVo", description = "费用上账表;")
public class TpmAccountDetailReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("分组id(标识同一次提交的数据)")
    private String groupId;

    @ApiModelProperty("状态")
    private String approveStatus;

    @ApiModelProperty("费用上账类型(字典:货补,现金)")
    private String accountType;

    @ApiModelProperty("上账编码")
    private String accountCode;

    @ApiModelProperty("核销编码")
    private String auditCode;

    @ApiModelProperty("核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty("活动编码(活动申请编码)")
    private String actCode;

    @ApiModelProperty("活动名称(活动申请名称)")
    private String actName;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("核销明细附加信息编码")
    private String auditDetailAttachCode;

    @ApiModelProperty("开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty("货补产品名称(冗余字段,查列表的时候用，逗号隔开)")
    private String productNames;

    @ApiModelProperty("支付方式编码")
    private String payType;

    @ApiModelProperty("支付方式名称")
    private String payTypeName;

    @ApiModelProperty("支付方式类型编码(字典)")
    private String payTypeType;

    @ApiModelProperty("上账金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("本次可上账金额")
    private BigDecimal currentAllowAmount;

    @ApiModelProperty("财务凭证编码")
    private String credentialsCode;

    @ApiModelProperty("核销科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("核销科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("ERP会计科目编码")
    private String financeSubjectsErpCode;

    @ApiModelProperty("ERP会计科目名称")
    private String financeSubjectsErpName;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("客户编码(归属客户)")
    private String customerCode;

    @ApiModelProperty("客户名称(归属客户)")
    private String customerName;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("活动大类编码(投入类型编码)")
    private String categoriesCode;

    @ApiModelProperty("活动大类名称(投入类型名称)")
    private String categoriesName;

    @ApiModelProperty("活动细类编码(活动类型编码)")
    private String fineCode;

    @ApiModelProperty("活动细类名称(活动类型名称)")
    private String fineName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品信息")
    private List<TpmAccountProductReqVo> replenishmentProductList;

    @ApiModelProperty("产品信息(产品编码)")
    private List<String> accountProductRespVos;

    @ApiModelProperty("活动登记明细附加信息编号")
    private String attachCode;

    @ApiModelProperty("所属销售公司(字典编码)")
    private String ownedSalesCompany;

    @ApiModelProperty("所属销售公司(字典名称)")
    private String ownedSalesCompanyName;

    @ApiModelProperty("申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private Set<String> selectedCodeList;

    @ApiModelProperty("附件集合")
    private List<TpmAccountFileVo> activityFileList;

    private List<String> orgCodes;

    @ApiModelProperty(value = "上账创建开始时间")
    private String commitBeginDate;

    @ApiModelProperty(value = "上账创建结束时间")
    private String commitEndDate;

    @ApiModelProperty("提交时间")
    private String submitTime;


    public String getUniqueKey(){
        return customerCode != null ? auditDetailCode + "-" + customerCode : auditDetailCode;
    }
}
