package com.biz.crm.nebular.tpm.account.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.account.TpmAccountFileVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用上账表;返回vo
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用上账表;")
@CrmColumnResolve
@SaturnEntity(name = "TpmAccountDetailRespVo", description = "费用上账表;")
public class TpmAccountDetailRespVo extends CrmExtVo {
    @ApiModelProperty("分组id(标识同一次提交的数据)")
    @SaturnColumn(description = "分组id(标识同一次提交的数据)")
    private String groupId;

    @ApiModelProperty("状态")
    @SaturnColumn(description = "状态")
    private String approveStatus;

    @ApiModelProperty("状态名称")
    @SaturnColumn(description = "状态名称")
    private String approveStatusName;

    @ApiModelProperty("费用上账类型(字典:货补,现金)")
    @SaturnColumn(description = "费用上账类型(字典:货补,现金)")
    private String accountType;

    @ApiModelProperty("上账编码")
    @SaturnColumn(description = "上账编码")
    private String accountCode;

    @ApiModelProperty("核销编码")
    @SaturnColumn(description = "核销编码")
    private String auditCode;

    @ApiModelProperty("核销明细编码")
    @SaturnColumn(description = "核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String actName;

    @ApiModelProperty("活动明细编码")
    @SaturnColumn(description = "活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("核销明细附加信息编码")
    @SaturnColumn(description = "核销明细附加信息编码")
    private String auditDetailAttachCode;

    @ApiModelProperty("开始日期")
    @SaturnColumn(description = "开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    @SaturnColumn(description = "开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    @SaturnColumn(description = "结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    @SaturnColumn(description = "结束时间")
    private String endDateSecond;

    @ApiModelProperty("核销金额")
    @SaturnColumn(description = "核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty("货补产品名称(冗余字段,查列表的时候用)")
    @SaturnColumn(description = "货补产品名称(冗余字段,查列表的时候用)")
    private String productNames;

    @ApiModelProperty("支付方式编码")
    @SaturnColumn(description = "支付方式编码")
    private String payType;

    @ApiModelProperty("支付方式名称")
    @SaturnColumn(description = "支付方式名称")
    private String payTypeName;

    @ApiModelProperty("支付方式类型编码(字典)")
    @SaturnColumn(description = "支付方式类型编码(字典)")
    private String payTypeType;

    @ApiModelProperty("支付方式类型名称(字典)")
    @SaturnColumn(description = "支付方式类型名称(字典)")
    private String payTypeTypeName;

    @ApiModelProperty("上账金额")
    @SaturnColumn(description = "上账金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("本次可上账金额")
    @SaturnColumn(description = "本次可上账金额")
    private BigDecimal currentAllowAmount;

    @ApiModelProperty("财务凭证编码")
    @SaturnColumn(description = "财务凭证编码")
    private String credentialsCode;

    @ApiModelProperty("核销科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("核销科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("ERP会计科目编码")
    private String financeSubjectsErpCode;

    @ApiModelProperty("ERP会计科目名称")
    private String financeSubjectsErpName;


    @ApiModelProperty("企业组织编码")
    @SaturnColumn(description = "企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    @SaturnColumn(description = "企业组织名称")
    private String orgName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("门店编码")
    @SaturnColumn(description = "门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @SaturnColumn(description = "门店名称")
    private String terminalName;

    @ApiModelProperty("活动大类编码")
    @SaturnColumn(description = "活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动大类名称")
    @SaturnColumn(description = "活动大类名称")
    private String categoriesName;

    @ApiModelProperty("活动细类编码")
    @SaturnColumn(description = "活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    @SaturnColumn(description = "活动细类名称")
    private String fineName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品数据")
    @SaturnColumn(description = "产品数据")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmAccountProductRespVo> replenishmentProductList;

    @ApiModelProperty("产品信息(产品编码)")
    @SaturnColumn(description = "产品数据(产品编码)")
    private List<String> accountProductRespVos;

    @ApiModelProperty("活动登记明细附加信息编号")
    @SaturnColumn(description = "活动登记明细附加信息编号")
    private String attachCode;

    @ApiModelProperty("所属销售公司(字典编码)")
    @SaturnColumn(description = "所属销售公司(字典编码)")
    private String ownedSalesCompany;

    @ApiModelProperty("所属销售公司(字典名称)")
    @SaturnColumn(description = "活动细类名称")
    private String ownedSalesCompanyName;

    @ApiModelProperty("申请金额")
    @SaturnColumn(description = "申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("提交时间")
    private String submitTime;

    @ApiModelProperty("附件集合")
    private List<TpmAccountFileVo> activityFileList;

}
