package com.biz.crm.nebular.tpm.audit;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.tpm.act
 * @ClassName TpmActDetailProductVo
 * @Author HuangLong
 * @Date 2021/6/9 14:06
 * @Description TODO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "核销明细货补产品表vo")
@CrmColumnResolve
public class TpmAuditDetailReplenishmentProductVo extends CrmExtTenVo {

    @ApiModelProperty("核销编码")
    private String auditCode;

    @ApiModelProperty("核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;
}
