package com.biz.crm.nebular.tpm.budgetsubjects.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Set;

/**
 * 预算科目 请求vo
 *
 * @author huang.long
 * @date 2020-09-09 13:40:31
 */
@Setter
@Getter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmBudgetSubjectsReqVo", description = "预算科目 ")
public class TpmBudgetSubjectsReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("预算科目编号")
    private String budgetSubjectsCode;

    @ApiModelProperty("预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("预算科目类型")
    private String subjectsTypeCode;

    @ApiModelProperty("预算科目分组")
    private String subjectsGroupCode;

    @ApiModelProperty("是否滚动")
    private String isRoll;

    @ApiModelProperty("控制类型")
    private String controlType;

    @ApiModelProperty("上级科目编码")
    private String parentSubjectsCode;

    @ApiModelProperty("是否为活动费用")
    private String isActBudget;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private Set<String> selectedCodeList;

}