package com.biz.crm.nebular.tpm.feebudget.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.math.BigDecimal;
import java.util.Set;

import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 费用预算 请求vo
 *
 * @author huanglong
 * @date 2020-09-14 17:11:59
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmFeeBudgetReqVo", description = "费用预算 ")
public class TpmFeeBudgetReqVo extends CrmExtVo {

    /**
     * 操作类型,主要是在控制维度那里用(1,审批通过,2,审批驳回,3.使用费用预算)
     */
    private int operateType;

    @ApiModelProperty("关联管控维度表id")
    private String controlId;

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("控制维度ID集合")
    private List<String> controlIds;

    @ApiModelProperty("费用预算编码")
    private String feeBudgetCode;

    @ApiModelProperty("费用预算类型(字典)")
    private String feeBudgetType;

    @ApiModelProperty("费用预算类型名称")
    private String feeBudgetTypeName;

    @ApiModelProperty("预算年份(字典)")
    private String budgetYear;

    @ApiModelProperty("预算季度(字典)")
    private String budgetQuater;

    @ApiModelProperty("预算月份(字典)")
    private String budgetMonth;

    @ApiModelProperty("客户所属组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户所属组织编码")
    private String customerOrgName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("预算科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("期初金额")
    private BigDecimal initAmount;

    @ApiModelProperty("调整金额")
    private BigDecimal adjustTotalAmount;

    @ApiModelProperty("调整后金额")
    private BigDecimal afterAdjustAmount;

    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmount;

    @ApiModelProperty("可用余额")
    private BigDecimal canUseAmount;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("企业组织类型")
    private String orgType;

    @ApiModelProperty("企业组织类型名称")
    private String orgTypeName;

    @ApiModelProperty("渠道(字典)")
    private String channel;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("变更类型(明细类型)")
    private String feeBudgetDetailType;

    @ApiModelProperty("费用预算变更调整备注")
    private String businessRemarks;

    @ApiModelProperty("变更金额")
    private BigDecimal changeAmount;

    @ApiModelProperty("调入方费用预算id")
    private String adjustInFeeBudgetId;

    @ApiModelProperty("调入方费用预算编码")
    private String adjustInFeeBudgetCode;

    @ApiModelProperty("预算科目控制类型")
    private String budgetSubjectsControlType;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private Set<String> selectedCodeList;

    @ApiModelProperty("月份搜索条件---开始月份")
    private Integer budgetMonthBegin;

    @ApiModelProperty("月份搜索条件---结束月份")
    private Integer budgetMonthEnd;

    /**
     * 是否收入预算生成
     */
    private Boolean isIncomeGenerate = false;
}