package com.biz.crm.nebular.tpm.feewithholding.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 返回vo
 *
 * @author gavin
 * @date 2021-12-15 15:36:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用预提手工预提(活动明细)")
public class TpmFeeWithholdingRespVo extends CrmExtTenVo {
    @ApiModelProperty("预提类型字典值")
    private String withholdingType;

    @ApiModelProperty("预提类型")
    private String withholdingTypeName;

    @ApiModelProperty("推送状态字典值")
    private String sendStatus;

    @ApiModelProperty("推送状态")
    private String sendStatusName;

    @ApiModelProperty("预提编码")
    private String withholdingCode;

    @ApiModelProperty("预提年月")
    private String yearAndMonth;

    @ApiModelProperty("预提金额")
    private BigDecimal withholdingAmount;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("活动大类名称")
    private String categoriesName;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("已上账金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("费用申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("支付方式")
    private String payTypeName;
}