package com.biz.crm.nebular.tpm.floatfeebudget.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * @author Administrator
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmFloatFeeBudgetReqVo", description = "变动预算 ")
public class TpmFloatFeeBudgetReqVo extends CrmExtVo {








    @ApiModelProperty("ID集合")
    private List<String> ids;

    /**
     * 费用预算编码
     */
    @ApiModelProperty("费用预算编码")
    private String feeBudgetCode;

    /**
     * 费用预算类型(字典)
     */
    @ApiModelProperty("费用预算类型")
    private String feeBudgetType;

    /**
     * 预算年份(字典)
     */
    @ApiModelProperty("预算年份")
    private String budgetYear;

    /**
     * 预算季度(字典)
     */
    @ApiModelProperty("预算季度")
    private String budgetQuater;

    /**
     * 预算月份(字典)
     */
    @ApiModelProperty("预算月份")
    private String budgetMonth;

    /**
     * 客户所属组织编码
     */
    @ApiModelProperty("客户所属组织编码")
    private String customerOrgCode;
    /**
     * 客户所属组织名称
     */
    @ApiModelProperty("客户所属组织名称")
    private String customerOrgName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * 预算科目编码
     */
    @ApiModelProperty("预算科目编码")
    private String budgetSubjectsCode;

    /**
     * 产品层级编码（品牌）
     */
    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    /**
     *产品层级名称
     */
    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;

    /**
     * 期初金额
     */
    @ApiModelProperty("期初金额")
    private BigDecimal initAmount;
    /**
     * 调整金额
     */
    @ApiModelProperty("调整金额")
    private BigDecimal adjustTotalAmount;

    /**
     * 调整后金额
     */
    @ApiModelProperty("调整后金额")
    private BigDecimal afterAdjustAmount;

    /**
     * 已使用金额
     */
    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmount;
    /**
     * 可用余额
     */
    @ApiModelProperty("可用余额")
    private BigDecimal canUseAmount;
    /**
     * 企业组织编码
     */
    @ApiModelProperty("企业组织编码")
    private String orgCode;

    /**
     * 企业组织名称
     */
    @ApiModelProperty("企业组织名称")
    private String orgName;

    /**
     * 企业组织类型
     */
    @ApiModelProperty("企业组织类型")
    private String orgType;

    /**
     * 企业组织类型名称
     */
    @ApiModelProperty("企业组织类型名称")
    private String orgTypeName;

    /**
     * 渠道(字典)
     */
    @ApiModelProperty("渠道")
    private String channel;

    /**
     * 终端编码
     */
    @ApiModelProperty("终端编码")
    private String terminalCode;

    /**
     * 终端名称
     */
    @ApiModelProperty("终端名称")
    private String terminalName;


    /**
     * 费率
     */
    @ApiModelProperty("费率")
    private BigDecimal rate;
    /**
     * 终端销售金额
     */
    @ApiModelProperty("终端销售金额")
    private BigDecimal terminalSalesAmount;

    /**
     * 申请费用占比
     */
    @ApiModelProperty("申请费用占比")
    private BigDecimal applicationFeePercentage;


    /**
     * 核销费用占比
     */
    @ApiModelProperty("核销费用占比")
    private BigDecimal percentageOfWriteOffExpenses;


    /**
     * 是否超额 YesNoEnum
     */
    @ApiModelProperty("是否超额")
    private String whetherItIsOver;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private Set<String> selectedCodeList;

}
