package com.biz.crm.nebular.tpm.liqueuract.resp;

import com.biz.crm.common.DictItemVo;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 活动信息主表;返回vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动信息主表;")
@CrmColumnResolve
public class TpmLiqueurActRespVo extends CrmExtVo {
    @ApiModelProperty("活动类型(活动细类)")
    private String fineCode;

    @ApiModelProperty("活动类型名称")
    private String fineName;

    @ApiModelProperty("销售公司")
    private String saleCompany;

    @ApiModelProperty("销售公司")
    private String saleCompanyDesc;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("是否跨组织")
    private String isCrossOrg;

    @ApiModelProperty("是否跨组织描述")
    private String isCrossOrgDesc;

    @ApiModelProperty("责任组织")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("客户")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("组织")
    private List<MdmOrgRespVo> orgList;

    @ApiModelProperty("客户")
    private List<MdmCustomerMsgSelectRespVo> customerList;

    @ApiModelProperty("审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("审批状态名称")
    private String approveStatusName;

    @ApiModelProperty("是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("是否完全核销")
    private String isAllAuditDesc;

    @ApiModelProperty("是否核销")
    private String isAudit;

    @ApiModelProperty("是否核销")
    private String isAuditDesc;

    @ApiModelProperty("开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("预算信息")
    private List<TpmLiqueurActBudgetRespVo> budgetVos;

    @ApiModelProperty("编辑查看时,费用预算的集合数据")
    private List<TpmFeeBudgetControlRespVo> editBudgetVos;

    @ApiModelProperty("附件信息")
    private List<TpmLiqueurActFileRespVo> fileVos;

    @ApiModelProperty("申请金额")
    private BigDecimal applyTotalAmount;

    @ApiModelProperty("核销金额")
    private BigDecimal auditTotalAmount;

    @ApiModelProperty("审批金额")
    private BigDecimal approveAmount;

    @ApiModelProperty("可用金额")
    private BigDecimal canUseAmount;

    @ApiModelProperty("核销截至日期")
    private String allowAuditEndDate;

    @ApiModelProperty("核销截至时间")
    private String allowAuditEndDateSecond;

    @ApiModelProperty("总登记金额")
    private BigDecimal registerTotalAmount;

    @ApiModelProperty("活动类型表单")
    private String costFormCode;

    @ApiModelProperty("核销表单编码")
    private String auditFormCode;

    @ApiModelProperty("总计")
    private BigDecimal total;

    @ApiModelProperty("是否可以登记明细标记")
    private String isAllowRegisterDetail;

    @ApiModelProperty("是否允许多次核销")
    private String isAllowRepeatAudit;
}