package com.biz.crm.nebular.tpm.liqueuraudit.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditDetailsRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditFileRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 酒类TPM核销申请主表;请求vo
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmLiqueurAuditReqVo", description = "酒类TPM核销申请主表;")
public class TpmLiqueurAuditReqVo extends CrmBaseVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("核销申请名称")
    private String auditName;

    @ApiModelProperty("核销申请编码")
    private String auditCode;

    @ApiModelProperty("审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("审批主题")
    private String title;

    @ApiModelProperty("审批备注")
    private String approveRemarks;

    @ApiModelProperty("审批文件集合")
    private List<TpmAuditFileRespVo> activityFileVos;

    @ApiModelProperty("核销明细集合")
    private List<TpmLiqueurAuditDetailsReqVo> detailsVos;

    @ApiModelProperty("保存类型:1新增暂存,2,新增并提交审批,3,修改暂存,4修改并提交审批,5,提交审批")
    private String saveType;

    @ApiModelProperty("细类编码")
    private String fineCode;

    @ApiModelProperty("细类名称")
    private String fineName;

    @ApiModelProperty("核销明细表单配置编码")
    private String auditFormCode;

    @ApiModelProperty("是否允许多次核销")
    private String isAllowRepeatAudit;


    @ApiModelProperty("是否需要占用预算")
    private Boolean occupyFeeBudgetFlag=false;

    @ApiModelProperty("占用预算明细列表")
    private List<TpmLiqueurAuditDetailsReqVo> occupyFeeBudgetDetails;

    @ApiModelProperty("核销附加信息集合")
    private List<TpmLiqueurAuditAttachReqVo> attachVos;

    @ApiModelProperty("核销物料信息集合")
    private List<Object> materialsVos;

    @ApiModelProperty("上账核销金额")
    private BigDecimal billAuditAmount;

    @ApiModelProperty("物料核销金额")
    private BigDecimal materialsAmount;


}
