package com.biz.crm.nebular.tpm.liqueuraudit.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 酒类TPM核销附加信息表;返回vo
 *
 * @author lf
 * @date 2021-03-23 11:48:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类TPM核销附加信息表;")
@CrmColumnResolve
public class TpmLiqueurAuditAttachRespVo extends CrmExtVo {
    @ApiModelProperty("登记单号")
    private String actRegisterCode;

    @ApiModelProperty("核销明细附加信息编码")
    private String auditDetailAttachCode;

    @ApiModelProperty("活动登记明细附加信息编码")
    private String attachCode;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动明细名称")
    private String actDetailName;

    @ApiModelProperty("投入类型编码")
    private String categoriesCode;

    @ApiModelProperty("投入类型名称")
    private String categoriesName;

    @ApiModelProperty("所属销售公司(字典编码)")
    private String ownedSalesCompany;

    @ApiModelProperty("所属销售公司(字典名称)")
    private String ownedSalesCompanyName;

    @ApiModelProperty("所属客户(编码)")
    private String ownedCusCodes;

    @ApiModelProperty("所属客户名称")
    private String ownedCusCodesName;

    @ApiModelProperty("支付类型")
    private String payType;

    @ApiModelProperty("支付方式名称")
    private String payTypeName;

    @ApiModelProperty("支付方式类型")
    private String payTypeType;

    @ApiModelProperty("归属客户编码")
    private String attributionCusCode;

    @ApiModelProperty("归属客户名称")
    private String attributionCusName;

    @ApiModelProperty("归属季度")
    private String attributionQuarter;

    @ApiModelProperty("归属月份")
    private String attributionMonth;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品类型")
    private String productType;

    @ApiModelProperty("单位编码")
    private String unit;

    @ApiModelProperty("单位名称")
    private String unitName;

    @ApiModelProperty("单价")
    private BigDecimal price;

    @ApiModelProperty("申请数量")
    private String applyNumber;

    @ApiModelProperty("申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("审批数量")
    private String approvalNumber;

    @ApiModelProperty("审批金额")
    private BigDecimal approvalAmount;

    @ApiModelProperty("支付人")
    private String payMan;

    @ApiModelProperty("开户行")
    private String accountBank;

    @ApiModelProperty("账号")
    private String account;

    @ApiModelProperty("核销申请编码")
    private String auditCode;

    @ApiModelProperty("核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty("核销金额")
    @SaturnColumn(description = "核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty("是否完全核销（Y/N）")
    private String isAllAudit;

    @ApiModelProperty("可上账金额")
    private BigDecimal currentAllowAmount;

    @ApiModelProperty("已上账金额")
    private BigDecimal feeUsed;

    @ApiModelProperty("是否完全上账（Y/N）")
    private String isAllFeeUsed;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("核销科目编码")
    private String auditSubjectCode;

    @ApiModelProperty("核销科目名称")
    private String auditSubjectName;

    @ApiModelProperty("活动类型编码(细类)")
    private String fineCode;

    @ApiModelProperty("活动类型名称(细类)")
    private String fineName;

    @ApiModelProperty("开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("客户编码")
    private String customerCode;

}
