package com.biz.crm.nebular.tpm.liqueuraudit.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditDetailsReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 酒类TPM核销申请主表;返回vo
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类TPM核销申请主表;")
@CrmColumnResolve
public class TpmLiqueurAuditRespVo extends CrmExtVo {
    @ApiModelProperty("核销申请名称")
    private String auditName;

    @ApiModelProperty("核销申请编码")
    private String auditCode;

    @ApiModelProperty("审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动类型编码(活动细类)")
    private String fineCode;

    @ApiModelProperty("核销明细表单配置编码")
    private String auditFormCode;

    @ApiModelProperty("是否允许多次核销")
    private String isAllowRepeatAudit;

    @ApiModelProperty("审批状态(字典)")
    private String approveStatusName;

    @ApiModelProperty("核销明细集合")
    private List<TpmLiqueurAuditDetailsRespVo> detailsVos;

    @ApiModelProperty("核销附加信息集合")
    private List<TpmLiqueurAuditAttachRespVo> attachVos;

    @ApiModelProperty("核销物料信息集合")
    private List<Object> materialsVos;

    @ApiModelProperty("上账核销金额")
    private BigDecimal billAuditAmount;

    @ApiModelProperty("物料核销金额")
    private BigDecimal materialsAmount;

}