package com.biz.crm.nebular.tpm.sale.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.Ext20Vo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 销售计划 返回vo
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "销售计划 ")
public class TpmSalesPlansRespVo extends Ext20Vo {

    @ApiModelProperty("岗位编码")
    private String positionCode;

    @ApiModelProperty("岗位名称")
    private String positionName;

    @ApiModelProperty("年")
    private String spYear;

    @ApiModelProperty("月")
    private String spMonth;

    @ApiModelProperty("类型")
    private String spType;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("金额")
    private BigDecimal amount;

    @ApiModelProperty("币种")
    private String currencyTypes;

    @ApiModelProperty("销售计划id")
    private String salePlansId;


}