package com.biz.crm.nebular.upload.vo;

import io.swagger.annotations.ApiModel;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Map;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.upload.vo
 * @ClassName WordTemplateDataVo
 * @Author Gavin
 * @Date 2021/3/20 下午12:06
 * @Description 模版数据映射Vo
 */

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel("文件路上传信息")
public class WordTemplateDataVo implements Serializable {
    private static final long serialVersionUID = 8461313996950120536L;

    /**
     * 生成文件名称
     */
    private String fileName;

    /**
     * 模版名称 DocumentTreatyMoney.xml
     */
    private String templateName;

    /**
     * docx模版压缩包名称 TreatyMoneyTemplate.zip
     */
    private String zipTemplateName;

    /**
     * 签名图片url https://bizcrm.oss-cn-beijing.aliyuncs.com/pdf/20210319/fa62e4e7b63541b8b1d86d1710b0c1e3.pdf
     */
    private String sginImageUrl;

    /**
     * 签名 位置 字符 代表（签字）
     */
    private String tabText;

    /**
     * 图章宽度
     */
    private Integer width = 80;

    /**
     * 图章高度
     */
    private Integer height = 80;

    /**
     * 图章在编辑段落向左偏移量
     */
    private Integer leftOffset = 320;

    /**
     * 图章在编辑段落向上偏移量
     */
    private Integer topOffset = -30;

    /**
     * 图章是否在文字下面
     */
    private Boolean behin = true;

    /**
     * 模版数据
     */
    private Map<String, Object> dataMap;
}