/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImportVo {
    public static final Set<String> BASE_IMPORT_COLUMNS = Sets.newHashSet((Object[])new String[]{"rowIndex", "processType", "validateMsg", "saveMsg"});
    @ExcelProperty(value={"\u539fExcel\u884c\u53f7"}, order=10000)
    private Integer rowIndex;
    @ExcelProperty(value={"\u5904\u7406\u7ed3\u679c"}, order=10001, converter=ProcessTypeEnumConverter.class)
    private ProcessTypeEnum processType = ProcessTypeEnum.SUCCESS;
    private static final String DEF_MSG = "\u6210\u529f;";
    private static final String FAIL_MSG = "\u5931\u8d25;";
    @ExcelProperty(value={"\u6821\u9a8c\u7ed3\u679c\u63cf\u8ff0"}, order=10002)
    private String validateMsg = "\u6210\u529f;";
    @ExcelProperty(value={"\u4fdd\u5b58\u7ed3\u679c\u63cf\u8ff0"}, order=10003)
    private String saveMsg = "\u6210\u529f;";

    public Set<String> superIgnore() {
        return Sets.newHashSet();
    }

    public void setRowIndex(Integer rowIndex) {
        if (null == rowIndex) {
            return;
        }
        this.rowIndex = rowIndex + 1;
    }

    public void appendErrorValidateMsg(String msg) {
        this.processType = ProcessTypeEnum.FAIL;
        this.saveMsg = FAIL_MSG;
        if (StringUtils.isBlank((CharSequence)msg)) {
            this.validateMsg = FAIL_MSG;
            return;
        }
        if (DEF_MSG.equals(this.validateMsg)) {
            this.validateMsg = msg;
            return;
        }
        this.validateMsg = this.validateMsg + msg;
    }

    public void appendErrorSaveMsg(String msg) {
        this.processType = ProcessTypeEnum.FAIL;
        if (StringUtils.isBlank((CharSequence)msg)) {
            return;
        }
        if (DEF_MSG.equals(this.saveMsg)) {
            this.saveMsg = msg;
            return;
        }
        this.saveMsg = this.saveMsg + msg;
    }

    public void appendSuccessSaveMsg(String msg) {
        this.processType = ProcessTypeEnum.SUCCESS;
        if (StringUtils.isBlank((CharSequence)msg)) {
            return;
        }
        if (DEF_MSG.equals(this.saveMsg)) {
            this.saveMsg = msg;
            return;
        }
        this.saveMsg = this.saveMsg + msg;
    }

    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public ProcessTypeEnum getProcessType() {
        return this.processType;
    }

    public void setProcessType(ProcessTypeEnum processType) {
        this.processType = processType;
    }

    public String getValidateMsg() {
        return this.validateMsg;
    }

    public String getSaveMsg() {
        return this.saveMsg;
    }

    public static class ProcessTypeEnumConverter
    implements Converter<ProcessTypeEnum> {
        public Class supportJavaTypeKey() {
            return ProcessTypeEnum.class;
        }

        public CellDataTypeEnum supportExcelTypeKey() {
            return CellDataTypeEnum.STRING;
        }

        public ProcessTypeEnum convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
            String data = cellData.getStringValue();
            if (StringUtils.isBlank((CharSequence)data)) {
                return null;
            }
            return ProcessTypeEnum.valueOf(data);
        }

        public CellData convertToExcelData(ProcessTypeEnum value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
            return new CellData(value.getDes());
        }
    }

    public static enum ProcessTypeEnum {
        SUCCESS("SUCCESS", "\u6210\u529f"),
        FAIL("FAIL", "\u5931\u8d25");

        private String value;
        private String des;

        private ProcessTypeEnum(String value, String des) {
            this.value = value;
            this.des = des;
        }

        public String getValue() {
            return this.value;
        }

        public String getDes() {
            return this.des;
        }
    }
}

