package com.biz.crm.config;

import com.alibaba.fastjson.JSON;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.IpUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: 用户未登录时返回给前端的数据
 * @date 2020/9/22 下午3:26
 */
@Component
@Slf4j
public class AjaxAuthenticationEntryPoint implements AuthenticationEntryPoint {
    @Override
    public void commence(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationException e) throws IOException, ServletException {
        String ip = IpUtil.getIpAddrByRequest(HttpServletRequestUtil.getRequest());
        log.error(httpServletRequest.getRequestURI()+"===>没有登录权限 -> [{}]", ip);
        Result result = new Result();
        result.error401("请重新登录");
        httpServletResponse.getWriter().write(JSON.toJSONString(result));
    }
}
