package com.biz.crm.dict.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.Set;

/**
 * 字典分类的记录信息
 *
 * @author zxw
 */
@ApiModel(value = "DictCategoryVo", description = " 字典分类的记录信息")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class DictCategoryVo {

    private String id;

    /**
     * 字典分类编码 *
     */
    @ApiModelProperty(name = "cateCode", value = "字典分类编码", required = true)
    private String cateCode;

    /**
     * 字典分类名称. *
     */
    @ApiModelProperty(name = "DictCategoryVo\n" +
            "DictExportVo\n" +
            "DictImportDetailVo\n" +
            "DictImportVo\n" +
            "DictItemVo\n" +
            "DictVocateName", value = "字典分类名称", required = true)
    private String cateName;

    /**
     * 字典分类描述. *
     */
    @ApiModelProperty(name = "cateDesc", value = "字典分类描述")
    private String cateDesc;

    /**
     * 父级分类
     */
    private DictCategoryVo parentCategory;

    /**
     * 子级分类
     */
    private Set<DictCategoryVo> childCategory;

    /**
     * 该分类下所有字典
     */
    private Set<DictVo> dicts;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "createAccount", value = "创建人", required = true)
    private String createAccount;

    /**
     * 最后修改人
     */
    @ApiModelProperty(name = "modifyAccount", value = "最后修改人", required = true)
    private String modifyAccount;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
    private Date createTime;

    /**
     * 最后更新时间
     */
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间", required = true)
    private Date modifyTime;

}
