package com.biz.crm.dict.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.Set;

/**
 * 字典的记录信息
 *
 * @Author: zengxingwang
 * @Date: 2020/3/21 11:42
 */
@ApiModel(value = "DictVo", description = " 字典的记录信息")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class DictVo {

    private String id;

    /**
     * 字典的类型编号. *
     */
    @ApiModelProperty(name = "dictCode", value = "字典类型编号", required = true)
    private String dictCode;

    /**
     * 字典的标题. *
     */
    @ApiModelProperty(name = "dictTitle", value = "字典的标题", required = true)
    private String dictTitle;

    /**
     * 字典的运营范围,先固定值为 通用/业务. *
     */
    @ApiModelProperty(name = "dictType", value = "字典的运营范围,先固定值为 通用/业务", required = true)
    private String dictType;

    /**
     * 父级分组
     */
    private DictCategoryVo category;

    /**
     * 字典明细数量. *
     */
    @ApiModelProperty(name = "itemNum", value = "字典明细数量", required = true)
    private Integer itemNum;

    /**
     * 字典的说明. *
     */
    @ApiModelProperty(name = "description", value = "字典说明")
    private String description;

    /**
     * 字典的启用状态
     */
    @ApiModelProperty(name = "dictStatus", value = "字典启用状态")
    private Boolean dictStatus;

    private Set<DictItemVo> dictItems;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
    private Date createTime;

    /**
     * 最后更新时间
     */
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间", required = true)
    private Date modifyTime;

    /**
     * 值类型
     */
    @ApiModelProperty(name = "valueType", value = "值类型", required = true)
    private String valueType;

}
