package com.biz.crm.dict.feign;

import com.biz.crm.dict.entity.MdmDictVo;
import com.biz.crm.nebular.mdm.dict.resp.DictRespVo;
import feign.hystrix.FallbackFactory;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author zxw
 **/
@FeignClient(url ="${feign.urlip:}",qualifier ="mdmKnlDictFeign" ,value="crm-mdm",path = "mdm",fallbackFactory = MdmKnlDictFeign.FallBackClass.class)
public interface MdmKnlDictFeign {


    @GetMapping("/dict/one")
    MdmDictVo one(@RequestParam("typeCode") String typeCode, @RequestParam("dictCode") String dictCode);

    @GetMapping("/dict/val")
    String val(@RequestParam("typeCode") String typeCode, @RequestParam("dictCode") String dictCode);

    @GetMapping("/dict/map")
    @ApiOperation("查询map")
    Map<String, String> list(@RequestParam("typeCode") String typeCode);

    @PostMapping("/dict/map_batch")
    List<DictRespVo> typeList(@RequestBody List<String> typeCodeList);


    @Component
    @Slf4j
    class FallBackClass implements FallbackFactory<MdmKnlDictFeign> {
        @Override
        public MdmKnlDictFeign create(Throwable throwable) {
            return new MdmKnlDictFeign() {

                @Override
                public MdmDictVo one(String typeCode, String dictCode) {
                    return null;
                }

                @Override
                public String val(String typeCode, String dictCode) {
                    log.error("远程查询数据字典失败:{}",throwable);
                    return null;
                }

                @Override
                public Map<String, String> list(String typeCode) {
                    log.error("远程查询数据字典失败:{}",throwable);
                    return Collections.emptyMap();
                }

                @Override
                public List<DictRespVo> typeList(List<String> typeCodeList) {
                    log.error("远程查询数据字典失败:{}",throwable);
                    return Collections.emptyList();
                }
            };
        }
    }

}
