package com.biz.crm.eunm.sfa;

import jodd.util.StringUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:sfa     公共常量
 * @Author: liuhongming
 * @Date: 2020/9/21 18:25
 **/
public class SfaCommonEnum {

    /**
     * 0 与 1 是否逻辑
     */
    public enum YesNoEnum {
        ZERO("0", "否"), ONE("1", "是"), TWO("2", "默认"), YES("Y", "是"), NO("N", "否"), Y("Y", "有"), N("N", "无");
        private String value;
        private String des;

        YesNoEnum(String value, String des) {
            this.value = value;
            this.des = des;
        }

        static Map<String, YesNoEnum> enumMap = new HashMap<>();

        static {
            for (YesNoEnum type : YesNoEnum.values()) {
                enumMap.put(type.getValue(), type);
            }
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDes() {
            return des;
        }

        public void setDes(String des) {
            this.des = des;
        }

        public static YesNoEnum getEnum(String value) {
            return enumMap.get(value);
        }
    }

    /**
     * 范围类型
     */
    public enum rangeTypeEnum {
        One("1","包含"),
        Two("2","非包含");
        private String val;
        private String desc;

        rangeTypeEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 范围数据类型
     */
    public enum dataTypeEnum {
        channel("1","渠道"),
        org("2","组织"),
        cust("3","客户");
        private String val;
        private String desc;

        dataTypeEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public enum clientTypeEnum {
        cust("01","经销商"),
        term("02","终端");
        private String val;
        private String desc;

        clientTypeEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 审批类型
     */
    public enum businessType {
        leave("0", "请假申请"),
        travel("1", "出差申请");

        private String value;
        private String desc;


        businessType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        static Map<String, SfaCommonEnum.businessType> enumMap = new HashMap<>();
        public static String REPLACE = "";

        static {
            for (SfaCommonEnum.businessType type : SfaCommonEnum.businessType.values()) {
                enumMap.put(type.getValue(), type);
                if (StringUtil.isNotEmpty(REPLACE)) {
                    REPLACE += ",";
                }
                REPLACE += type.getDesc() + "_" + type.getValue();
            }
        }

        public String getValue() {
            return value;
        }

        public Integer getIntValue() {
            return Integer.valueOf(value);
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Map<String, SfaCommonEnum.businessType> getEnumMap() {
            return enumMap;
        }

        public static String getTheDescBuVal(String val) {
            return enumMap.containsKey(val) ? enumMap.get(val).getDesc() : "";
        }


        public static String replaceStr() {
            SfaCommonEnum.businessType[] dataDownTypes = SfaCommonEnum.businessType.values();
            String str = "";
            for (int i = 0; i < dataDownTypes.length; i++) {
                str += dataDownTypes[i].desc + "_" + dataDownTypes[i].value;
                if (i != dataDownTypes.length - 1) {
                    str += ",";
                }
            }
            return str;
        }

    }


    /**
     * 请假加班审批状态
     */
    public enum dataBpmStatus {
        COMMIT("1", "已提交"),
        APPROVAL("2", "审批中"),
        PASS("3", "审批通过"),
        REJECT("4", "审批驳回");

        private String value;
        private String desc;


        dataBpmStatus(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        static Map<String, SfaCommonEnum.dataBpmStatus> enumMap = new HashMap<>();
        public static String REPLACE = "";

        static {
            for (SfaCommonEnum.dataBpmStatus type : SfaCommonEnum.dataBpmStatus.values()) {
                enumMap.put(type.getValue(), type);
                if (StringUtil.isNotEmpty(REPLACE)) {
                    REPLACE += ",";
                }
                REPLACE += type.getDesc() + "_" + type.getValue();
            }
        }

        public String getValue() {
            return value;
        }

        public Integer getIntValue() {
            return Integer.valueOf(value);
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Map<String, SfaCommonEnum.dataBpmStatus> getEnumMap() {
            return enumMap;
        }

        public static String getTheDescBuVal(String val) {
            return enumMap.containsKey(val) ? enumMap.get(val).getDesc() : "";
        }


        public static String replaceStr() {
            SfaCommonEnum.dataBpmStatus[] dataDownTypes = SfaCommonEnum.dataBpmStatus.values();
            String str = "";
            for (int i = 0; i < dataDownTypes.length; i++) {
                str += dataDownTypes[i].desc + "_" + dataDownTypes[i].value;
                if (i != dataDownTypes.length - 1) {
                    str += ",";
                }
            }
            return str;
        }

    }




    /**
     * 请假加班审批状态
     */
    public enum apiBpmStatus {
        COMMIT("1", "待审批"),
        PASS("2", "审批通过"),
        REJECT("3", "审批驳回");

        private String value;
        private String desc;


        apiBpmStatus(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        static Map<String, SfaCommonEnum.apiBpmStatus> enumMap = new HashMap<>();
        public static String REPLACE = "";

        static {
            for (SfaCommonEnum.apiBpmStatus type : SfaCommonEnum.apiBpmStatus.values()) {
                enumMap.put(type.getValue(), type);
                if (StringUtil.isNotEmpty(REPLACE)) {
                    REPLACE += ",";
                }
                REPLACE += type.getDesc() + "_" + type.getValue();
            }
        }

        public String getValue() {
            return value;
        }

        public Integer getIntValue() {
            return Integer.valueOf(value);
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Map<String, SfaCommonEnum.apiBpmStatus> getEnumMap() {
            return enumMap;
        }

        public static String getTheDescBuVal(String val) {
            return enumMap.containsKey(val) ? enumMap.get(val).getDesc() : "";
        }


        public static String replaceStr() {
            SfaCommonEnum.apiBpmStatus[] dataDownTypes = SfaCommonEnum.apiBpmStatus.values();
            String str = "";
            for (int i = 0; i < dataDownTypes.length; i++) {
                str += dataDownTypes[i].desc + "_" + dataDownTypes[i].value;
                if (i != dataDownTypes.length - 1) {
                    str += ",";
                }
            }
            return str;
        }

    }




}
