package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:sfa     拜访常量
 * @Author: liuhongming
 * @Date: 2020/9/21 18:25
 **/
public class SfaVisitEnum {

    /**
     * 拜访类型
     */
    public enum VisitType {
        temp_visit("01","临时拜访"), //临时拜访  计划外
        plan_visit("02","计划拜访"), //计划拜访-计划内
        assit_type("03","协访"); //协访
        private String val;
        private String desc;

        VisitType(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String,String> GETMAP = new HashMap<>();
        static {
            for (SfaVisitEnum.VisitType type : SfaVisitEnum.VisitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 拜访状态 拜访状态;0:未拜访 1:拜访中 2:已拜访
     */
    public enum VisitStatus {
        V1("0","未拜访"),
        V2("1","拜访中"),
        V3("2","已拜访");
        private String val;
        private String desc;

        VisitStatus(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String,String> GETMAP = new HashMap<>();
        static {
            for (SfaVisitEnum.VisitStatus type : SfaVisitEnum.VisitStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 维度类型（线路组、网点、频率	）
     */
    public enum routeTypeEnum{
        R1("1","线路组"),
        R2("2","网点"),
        R3("3","频率");
        private String val;
        private String desc;

        routeTypeEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String,String> GETMAP = new HashMap<>();
        static {
            for (SfaVisitEnum.routeTypeEnum type : SfaVisitEnum.routeTypeEnum.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }


        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }





}
