package com.biz.crm.exception.tpm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @Project crm
 * @PackageName com.biz.crm.exception.tpm
 * @ClassName FeeBudgetException
 * @Author HuangLong
 * @Date 2020/9/2 11:04
 * @Description 活动预付异常枚举
 */
public enum ActAdvancePayException implements CrmExceptionType {

    DATA_NOT_EXIST("tpm_80001","活动预付数据不存在"),
    DATA_DUPLICATE("tpm_80002","活动预付数据重复,请检查"),
    DATA_CODE_DUPLICATE("tpm_80003","活动预付编码已存在,请检查"),
    ;

    private String code;
    private String description;

    ActAdvancePayException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
