package com.biz.crm.exception.activiti;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @author weston
 * @date 2020-11-25
 */
public enum ActivitiException implements CrmExceptionType {


    ACT_PARAM_ERROR("act_10001","流程参数错误"),
    ACT_PARAM_FROM_NO("act_10002","缺少表单单号"),
    ACT_PARAM_COST_TYPE("act_10003","缺少表单类型"),
    ACT_PARAM_FORM_TYPE("act_10004","缺少来源系统"),
    ACT_PARAM_POS_CODE("act_10005","缺少人员岗位编码"),
    ACT_PARAM_SIGN("act_10006","缺少防重验证码"),
    ACT_PARAM_TITLE("act_10007","缺少标题"),
    ACT_PARAM_URL("act_10008","缺少页面URL"),
    ACT_PARAM_USER("act_10009","缺少用户编码"),
    ACT_PARAM_TASK_ID("act_10010","缺少任务节点ID"),
    ACT_PARAM_PROCESS_ID("act_10011","缺少流程实例ID"),
    ACT_PARAM_BTN("act_10012","缺少按钮编码"),
    ACT_PARAM_REMARK("act_10013","缺少备注信息"),
    ;

    private String code;
    private String description;

    ActivitiException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
