package com.biz.crm.util;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 集合工具类
 */
public class CollectionUtil {

	/**
	 * @Description: (判断collection集合不为空)  
	 * @param collection 集合类型
	 * @return
	 */
    public static boolean collectionNotEmpty(@SuppressWarnings("rawtypes") Collection collection) {
        return CollectionUtils.isNotEmpty(collection);
    }

    /**
	 * @Description: (判断list集合为空)  
	 * @param list 集合类型 
	 * @return
	 */
    public static boolean listEmpty(@SuppressWarnings("rawtypes") List list) {
        return CollectionUtils.isEmpty(list);
    }

    /**
	 * @Description: (判断list集合不为空)  
	 * @param list 集合类型 
	 * @return
	 */
    public static boolean listNotEmpty(@SuppressWarnings("rawtypes") List list) {
        return CollectionUtils.isNotEmpty(list);
    }

    /**
	 * @Description: (判断list集合不为空并且大小大于0)  
	 * @param list 集合类型 
	 * @return
	 */
    public static boolean listNotEmptyNotSizeZero(@SuppressWarnings("rawtypes") List list) {
        return listNotEmpty(list) && list.size() > 0;
    }

    /**
	 * @Description: (判断map集合不为空)  
	 * @param map 集合类型 
	 * @return
	 */
    public static boolean mapNotEmpty(@SuppressWarnings("rawtypes") Map map) {
        return MapUtils.isNotEmpty(map);
    }
    
    /**
     * 去重
  	 * @param list 集合类型
  	 * @return
  	 */
      public static List listDuplicate(List list) {
    	  List tempList= new ArrayList();  
    	    for(int i=0;i<list.size();i++){  
    	    	Object obj=list.get(i);
    	        if(!tempList.contains(obj)){
    	            tempList.add(obj);  
    	        }  
    	    }  
          return tempList;
      }
    
}
