package com.biz.crm.eunm.activiti;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Created by weston on 2017/5/7.
 */
public enum Column {

    // 是否有效
    VALID_IND(Indicator.VALID_IND_YES, Indicator.VALID_IND_NO),
    // 流程发布状态
    PROCESS_STATE(Indicator.PROCESS_STATE_EDIT, Indicator.PROCESS_STATE_DEPLOY),
    // 节点类型
    TASK_TYPE(Indicator.TASK_TYPE_HIS, Indicator.TASK_TYPE_RUN),
    // 通用性别
    COMMON_SEX(Indicator.COMMON_SEX_MAN, Indicator.COMMON_SEX_WOMAN),
    // 通用是否
    COMMON(Indicator.COMMON_YES, Indicator.COMMON_NO),
    //通用状态启用/禁用
    COMMON_STATE(Indicator.COMMON_ENABLE, Indicator.COMMON_DISABLE),
    //监听类类别
    LISTENER_TYPE(Indicator.LISTENER_TYPE_EXEC,Indicator.LISTENER_TYPE_WORK),

    MSG_READ(Indicator.MSG_READ_NO, Indicator.MSG_READ_NO),
    // 流程实例基础对象的状态
    ACT_BASE_STATUS(Indicator.ACT_BASE_STATUS_SAVE, Indicator.ACT_BASE_STATUS_DOING,
            Indicator.ACT_BASE_STATUS_FINISH, Indicator.ACT_BASE_STATUS_REJECT,
            Indicator.ACT_BASE_STATUS_END, Indicator.ACT_BASE_STATUS_DRAFT,
            Indicator.ACT_BASE_STATUS_CANCEL, Indicator.ACT_BASE_STATUS_RESTART,
            Indicator.ACT_BASE_STATUS_STOP),
    // 流程节点的类型
    NODE_TYPE(Indicator.NODE_TYPE_COMMON, Indicator.NODE_TYPE_ADD_SIGN, Indicator.NODE_TYPE_FORWARD),
    // 流程产生原因类型
    PROCESS_CAUSE_TYPE(Indicator.PROCESS_CAUSE_TYPE_COMMON, Indicator.PROCESS_CAUSE_TYPE_REJECT,
            Indicator.PROCESS_CAUSE_TYPE_FORWARD, Indicator.PROCESS_CAUSE_TYPE_ADD,
            Indicator.PROCESS_CAUSE_TYPE_CHILD),
    //费用表单状态
    COST_FORM_STATUS(Indicator.COST_FORM_STATUS_APPROVING,Indicator.COST_FORM_STATUS_APPROVED,
            Indicator.COST_FORM_STATUS_USING,Indicator.COST_FORM_STATUS_USED,
            Indicator.COST_FORM_STATUS_CLOSED,Indicator.COST_FORM_STATUS_SAVE,Indicator.COST_FORM_STATUS_INTERRUPT,
            Indicator.COST_FORM_STATUS_SUBMIT_FAIL,Indicator.COST_FORM_STATUS_REJECT,
            Indicator.COST_FORM_STATUS_RESUBMIT,Indicator.COST_FORM_STATUS_CANCEL),
    // 是否葡萄酒
    PRODUCT_WINE(Indicator.PRODUCT_WINE_TRUE, Indicator.PRODUCT_WINE_FALSE),
    // 重复是否跳过
    REPEAT_SKIP(Indicator.REPEAT_SKIP_FALSE,Indicator.REPEAT_SKIP_TRUE),
    // 为空是否跳过
    NULL_SKIP(Indicator.NULL_SKIP_FALSE, Indicator.NULL_SKIP_TRUE),
    // 是否忽略空
    IGNORE_NULL(Indicator.IGNORE_NULL_ONLY_YES,Indicator.IGNORE_NULL_NO,Indicator.IGNORE_NULL_PASS),
    // 尋崗方式
    QUERY_POS_TYPE(Indicator.QUERY_POS_TYPE_COMMON,Indicator.QUERY_POS_TYPE_ORG, Indicator.QUERY_POS_TYPE_ORG_UN,
            Indicator.QUERY_POS_DEPART_APPROVE, Indicator.QUERY_POS_DEPART_ADMIN),

    // 并行方式
    PARALLEL_STYLE(Indicator.PARALLEL_STYLE_NOT,Indicator.PARALLEL_STYLE_GROUP,
            Indicator.PARALLEL_STYLE_ONLY, Indicator.PARALLEL_STYLE_COMPETE),
    // 内部节点配置是否知会
    INSIDE_NOTICE(Indicator.INSIDE_NOTICE_YES,Indicator.INSIDE_NOTICE_NO),
    // 审批类型
    APPROVE_TYPE(Indicator.APPROVE_TYPE_COMMON, Indicator.APPROVE_TYPE_FINISH, Indicator.APPROVE_TYPE_AUDIT,
            Indicator.APPROVE_TYPE_RE,Indicator.APPROVE_TYPE_FI),
    // 流程操作冥等码类型
    TICKET_TYPE(Indicator.TICKET_TYPE_NEW, Indicator.TICKET_TYPE_ROLL_BACK, Indicator.TICKET_TYPE_STOP),
    // 流程操作冥等码状态
    TICKET_STATUS(Indicator.TICKET_STATUS_INIT, Indicator.TICKET_STATUS_FINISH, Indicator.TICKET_STATUS_ERROR),
    // 平均分配的查询类型
    AVERAGE_FIND_TYPE(Indicator.AVERAGE_FIND_TYPE_COMMON,Indicator.AVERAGE_FIND_TYPE_ORG)
    ;
    private Map<Integer, String> maps = new LinkedHashMap<>();

    Column(Indicator... values) {
        for (Indicator it : values) {
            maps.put(it.getCode(), it.getLabel());
        }
    }

    public String getLabelByCode(Integer code) {
        if (code == null) {
            return null;
        } else {
            return maps.get(code);
        }
    }


    public Map<Integer, String> getCodesAndLabels() {
        return maps;
    }

}
