package com.biz.crm.exception.mdm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @Project crm
 * @PackageName com.biz.crm.exception.mdm
 * @ClassName MdmProductException
 * @Author HuangLong
 * @Date 2020/9/2 11:04
 * @Description 商品异常枚举类
 */
public enum MdmProductException implements CrmExceptionType {

    PRODUCT_NULL("mdm_10001","商品数据不能为空"),
    PRODUCT_MATERIAL_NULL("mdm_10002","商品物料数据不能为空"),
    PRODUCT_MATERIAL_REPEAT("mdm_10002","商品物料数据不能重复"),
    PRODUCT_CODE_EXIST("mdm_10003","商品编码已存在"),
    PRODUCT_MATERIAL_ERROR("mdm_10004","标准商品只允许存在一种物料"),
    PRODUCT_NOT_EXIST("mdm_10005","商品数据异常"),
    ;

    private String code;
    private String description;

    MdmProductException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
