package com.biz.crm.util;

import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;

import java.util.HashMap;

/**
 * @author ren.gang
 * @ClassName SfaAuditUtils.java
 * @Description Sfa应用工作流相关工具类
 * @createTime 2020年12月03日 16:47:00
 */
public class SfaActivitiUtils {

    private static final String FORM_URL = "https";

    /**
     * 创建工作流审核请求信息
     * @param userCode 用户名
     * @param posCode 岗位编码
     * @param formNo 表单号
     * @param formTypeEnum 请求类型枚举
     * @return
     */
    public static StartProcessReqVo createStartProcessReqVO(String userCode, String posCode, String formNo
            , ActivitiEnum.FormTypeEnum formTypeEnum, String startDate, String endDate) {
        StartProcessReqVo process = new StartProcessReqVo();
        process.setUserCode(userCode);
        process.setPosCode(posCode);
        process.setProcessKey(formTypeEnum.getProcessKey());
        process.setFormNo(formNo);
        process.setTitle(formTypeEnum.getTitle() + "申请："+userCode+"("+startDate+"至"+endDate+")");
        process.setFormUrl(FORM_URL);
        process.setCallBackFeign(formTypeEnum.getCallBackFeign());
        process.setCostType(formTypeEnum.getCostType());
        process.setFormType(formTypeEnum.getFormType());
        process.setVariables(new HashMap<>());
        process.setSignTicket(System.currentTimeMillis()+"");

        return process;
    }
}
